DELIMITER $$
DROP PROCEDURE IF EXISTS V20231013123249__Create_ApplicantHostelOfferLetterEvent $$
CREATE PROCEDURE V20231013123249__Create_ApplicantHostelOfferLetterEvent()
BEGIN

IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='HOSTEL_SEND_OFFER_LETTER')) THEN
SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='Hostel');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'HOSTEL_SEND_OFFER_LETTER');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='HOSTEL_SEND_OFFER_LETTER');
INSERT INTO `system_msg_event`
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`, `uiDisplayCode`)
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'APPLICANT_HOSTEL_OFFER_LETTER', 'Applicant Hostel Offer Letter', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Applicant Hostel Offer Letter','Applicant Hostel Offer Letter');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


-- Template data provider for the Event

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPLICANT_HOSTEL_OFFER_LETTER_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPLICANT_HOSTEL_OFFER_LETTER_RCPNT', 'SQL');

-- Create Recipient Type

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_HOSTEL_OFFER_LETTER_RCPNT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'APPLICANT_HOSTEL_OFFER_LETTER_RCPNT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_HOSTEL_OFFER_LETTER_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='APPLICANT_HOSTEL_OFFER_LETTER_RCPNT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);


-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_HOSTEL_OFFER_LETTER_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT DISTINCT T1.id AS USER_ID,T1.academyLocationId AS ACADEMY_LOCATION_IDS FROM hostel_offer_detail T1 WHERE T1.id IN (namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_HOSTEL_OFFER_LETTER_RCPNT');
INSERT INTO sql_dtprovider (id, dataProviderId, sqlQuery, jsonString) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT DISTINCT
    T1.id AS ID,
    T3.code AS APPLICATION_ID,
    T2.firstName AS FIRST_NAME,
	T2.emailId AS EMAIL_ID,
    T2.firstName AS APP_FIRST_NAME,
    T2.middleName AS APP_MIDDLE_NAME,
    T2.lastName AS APP_LAST_NAME,
    T4.logoUrl AS LOGO_URL,
	'APPLICANT' AS USER_TYPE_KEY,
     ml.code as LANGUAGE_KEY,
    (CASE
        WHEN
            T4.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T4.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T4.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T4.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL
FROM
    hostel_offer_detail T1
        LEFT OUTER JOIN
    applicant_person T2 ON T1.applicantPersonId = T2.id
        LEFT OUTER JOIN
    application T3 ON T3.applicantPersonId = T2.id
        LEFT OUTER JOIN
    academy_location T4 ON T4.id = T1.academyLocationId
     LEFT OUTER JOIN
	multi_language ml on ml.id=T2.correspondence_language
    LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE
    T1.id IN (namedParams)",'{
 "id": 1,
     "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "APPLICATION_ID",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "APP_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "APP_LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "middleName",
            "resultKey": "APP_MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 6
        }
    ]}');

SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='APPLICANT_HOSTEL_OFFER_LETTER_DL');
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='APPLICANT_HOSTEL_OFFER_LETTER');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='HOSTEL_SEND_OFFER_LETTER');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='APPLICANT_HOSTEL_OFFER_LETTER_RCPNT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
VALUES(@msgtemplateconfigId+1,'Applicant Hostel Offer Letter Template',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Applicant Hostel Offer Letter Template',NULL,b'0',NULL,b'0','APPROVED',b'0','1','System Administrator','1',b'1','English');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`)
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Applicant Hostel Offer Letter','<html>
<head>
	<title></title>
	<script src="chrome-extension://mooikfkahbdckldjjndioackbalphokd/assets/prompt.js"></script>
</head>
<body data-gr-ext-installed="" data-new-gr-c-s-check-loaded="14.1122.0">
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; height:120px;">
			<td align="center" style="margin:0px;"><img height="120" src="$recipientData[&quot;HEADER_URL&quot;]" width="100%" /></td>
		</tr>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p align="left">$recipientData[&quot;APPLICATION_ID&quot;]</p>

			<p align="left">Dear $recipientData[&quot;APP_FIRST_NAME&quot;] $recipientData[&quot;APP_LAST_NAME&quot;]</p>

			<p>We have been sent offer Letter</p>
			</td>
		</tr>
		<tr>
			<td align="center" style="margin:0px; padding:0px;"><img height="80" src="$recipientData[&quot;FOOTER_URL&quot;]" width="100%" /></td>
		</tr>
	</tbody>
</table>
</body>
<grammarly-desktop-integration data-grammarly-shadow-root="true"></grammarly-desktop-integration></html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`)
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','Applicant Hostel Offer Letter','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; height:120px;">
            <td align="center" style="margin:0px;"><img height="120" src="$recipientData[&quot;HEADER_URL&quot;]" width="100%" /></td>
        </tr>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			 <p align="left"> $recipientData[&quot;APPLICATION_ID&quot;] </p>
			 <p align="left">Dear $recipientData[&quot;APP_FIRST_NAME&quot;] $recipientData[&quot;APP_LAST_NAME&quot;] </p>
             <p>We have been sent offer Letter </p>
			</td>
		</tr><tr>
            <td align="center" style="margin:0px; padding:0px;"><img height="80" width="100%" src="$recipientData[&quot;FOOTER_URL&quot;]" /></td>
        </tr>
	</tbody>
</table>
</body>
</html>');

SET @dydtdocumenttypeId=(SELECT MAX(id) FROM `dydt_document_type`);
INSERT INTO `dydt_document_type` (`id`,`typeName`, `configLevelCode`, `whetherDeletable`, `typeCode`, `availableForAdhoc`, `whetherEditable`)
VALUES (@dydtdocumenttypeId+1,'HOSTEL_OFFER_LETTER', 'ACADEMY_LOCATION_LEVEL', '0', 'HOSTEL_OFFER_LETTER', '0', '1');
SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @sysmsgevtrcpntdocId=(SELECT MAX(id) FROM `sys_msg_evt_rcpnt_doc`);
SET @msgscopeparamId=(select id from msg_scope_param where paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_rcpnt_doc`(`id`,`sysMsgEvtRcpntDefaultConfigId`,`docTypeId`,`docGenOwnerMappingDef`,`docGenParamMapDef`)
VALUES(@sysmsgevtrcpntdocId+1,@sysmsgevtrcptdefaultconfId,@dydtdocumenttypeId+1,@msgscopeparamId,'[{"MSG_PARAM":"CONTEXT_RECORD_ID","DOC_GEN_PARAM":"PRM_HOSTEL_OFFER_DETAIL_ID"}]');
-- Start : Mapping of Dynamic Document to MsgTemplate
SET @msgtemplateconfigdocId=(SELECT MAX(id) FROM `msg_template_config_doc`);
INSERT INTO `msg_template_config_doc` (`id`,`msgTemplateconfigId`, `sysMsgEvtRcpntdocId`) VALUES (@msgtemplateconfigdocId+1,@msgtemplateconfigId+1,@sysmsgevtrcpntdocId+1);
-- End : Mapping of Dynamic Document to Msgtemplate
SET @dydtdataproviderId=(SELECT MAX(id) FROM `dydt_data_provider`);
INSERT INTO `dydt_data_provider` (`id`,`providerName`, `priority`) VALUES (@dydtdataproviderId+1,'Applicant Hostel Details', '1');
SET @dydtdocumentdataproviderId=(SELECT MAX(id) FROM `dydt_document_data_provider`);
INSERT INTO `dydt_document_data_provider` (`id`,`dataProviderId`, `documentTypeId`) VALUES (@dydtdocumentdataproviderId+1,@dydtdataproviderId+1, @dydtdocumenttypeId+1);
-- COMPLETE_ADMISSION_INPUT_PARAMETER this is first data provider for document gen
SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`,
`sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId+1, 'APPLICANT_HOSTEL_DETAILS_INFO', '1',null,'1', '1',
'SELECT
T1.id AS id,
T2.firstName AS applicant_first_name,
T2.middleName AS applicant_middle_name,
T2.lastName AS applicant_last_name,
T3.code as applicant_id,
T3.primaryEmailId AS applicant_primary_email_id,
CONCAT(T2.mobileCountryCode,T2.mobileNumber) AS applicant_mobile_no,
T2.birthDate AS applicant_dob,
T7.displayName AS academy_location_print_name,
T9.addressText AS academy_location_address_box_postal_address,
T11.countryName AS academy_location_country_postal_address,
T10.countryRegionName AS academy_location_country_region_postal_address,
T12.cityName AS academy_location_city_postal_address,
T9.pincode AS academy_location_pincode_postal_address,
T1.offerLetterIssueDate AS offer_letter_issue_date,
T1.offerLetterExpiryDate AS offer_letter_expiry_date,
T1.hostelFeeAmount AS fee_amount,
T7.logoUrl AS img_academy_location_logo,
T7.headerUrl AS img_header_url,
T7.footerUrl AS img_footer_url,
T4.itemValue AS hostel_student_category_csm,
T6.locationName AS location,
T5.categoryCode AS reservation_category_csm
from hostel_offer_detail T1
left join applicant_person T2 on T2.id=T1.applicantPersonId
left join application T3 on T3.applicantPersonId=T2.id
left join hostel_student_category T4 on T4.id=T1.hostelStudentCategoryId
left join reservation_category T5 on T5.id=T1.reservationCategoryId
left join locations T6 on T6.id =T1.locationId
left join academy_location T7 on T7.id =T3.issuedFromAcademyLocation
left join academy_location_addresses T8 on T8.academyLocationId =T7.id
left join address T9 on T8.addressId =T9.id AND T9.addressTypeId=11
left join country_region T10 on T10.id =T9.parentRegionId
left join country T11 on T10.countryId =T11.id
left join city T12 on T12.id =T9.cityId', 'PRM_HOSTEL_OFFER_DETAIL_ID',
    'applicant_first_name,applicant_middle_name,applicant_last_name,applicant_id,applicant_primary_email_id,applicant_mobile_no,applicant_dob,
    academy_location_print_name,academy_location_address_box_postal_address,academy_location_country_postal_address,
academy_location_country_region_postal_address,academy_location_city_postal_address,academy_location_pincode_postal_address,offer_letter_issue_date,offer_letter_expiry_date,
fee_amount,img_academy_location_logo,img_header_url,img_footer_url,hostel_student_category_csm,location,reservation_category_csm,',
'where T1.id=PRM_HOSTEL_OFFER_DETAIL_ID', '0');
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('applicant_first_name', 'Applicant First Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('applicant_middle_name', 'Applicant Middle Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('applicant_last_name', 'Applicant Last Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('applicant_id', 'Applicant ID',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('applicant_primary_email_id', 'Applicant Primary Email ID',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('applicant_mobile_no', 'Applicant Mobile No.',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('applicant_dob', 'Applicant Date of birth',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('academy_location_print_name', 'Academy location print name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('academy_location_address_box_postal_address', 'Academy Location Address Box-Postal Address',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('academy_location_country_postal_address', 'Academy Location Country-Postal Address',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('academy_location_country_region_postal_address', 'Academy Location Country Region-Postal Address',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('academy_location_city_postal_address', 'Academy Location City-Postal Address',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('academy_location_pincode_postal_address', 'Academy Location Pin Code-Postal Address',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('offer_letter_issue_date', 'Offer Letter Issue Date',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('offer_letter_expiry_date', 'Offer Letter Expiry Date',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('fee_amount', 'Fee Amount',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('img_academy_location_logo', 'Academy location logo',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('img_header_url', 'Header URL',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('img_footer_url', 'Footer URL',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('hostel_student_category_csm', 'Student Category-CSM',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('location', 'Location',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('reservation_category_csm', 'Reservation category-CSM',@dydtdatalinitemId+1);
SET @dydtTemplateconfId=(SELECT MAX(id) FROM `dydt_template_conf`);
INSERT INTO `dydt_template_conf` (`id`, `documentTypeId`, `templateName`, `templateType`, `whetherDefault`,`templateContent`)
VALUES (@dydtTemplateconfId+1, @dydtdocumenttypeId+1, 'HOSTEL OFFER LETTER', 'HTMLTEMPLATE', '0','');


END IF;

END $$
CALL V20231013123249__Create_ApplicantHostelOfferLetterEvent () $$ 
DROP PROCEDURE IF EXISTS V20231013123249__Create_ApplicantHostelOfferLetterEvent $$ 
DELIMITER ;